package gov.vha.isaac.utils.file_transfer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import gov.vha.isaac.utils.file_transfer.Config.Artifact;
import org.junit.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit test for simple App.
 */
public class ConfigTest 
    extends TestCase
{
    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public ConfigTest( String testName )
    {
        super( testName );
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        return new TestSuite( ConfigTest.class );
    }

	private static Set<String> asSet(String...strs) {
		if (strs == null || strs.length == 0) {
			return null;
		} else {
			Set<String> set = new HashSet<>();
			for (String str : strs) {
				set.add(str);
			}
			
			return set;
		}
	}
    /**
     * Rigourous Test :-)
     */
    public void testApp()
    {
		/*
		{
			"properties":{
					"isaac-parent.version":"3.06",
					"isaac.version":"1.8"
				},
			"artifacts":[
				{
					 "group":"gov.vha.isaac.ochre",
					 "artifact":"isaac-parent",
					 "version":"${isaac-parent.version}",
					 "classifier":null,
					 "types":[
						"pom"
						]
				},
				{
					"group":"gov.vha.isaac.ochre.modules",
					"artifact":"db-builder",
			 		"version":"${isaac-parent.version}",
					"classifier":null,
					"types":[
						"pom"
					]
				},
				{
					"group":"gov.vha.isaac.rest",
					"artifact":"isaac-rest",
					"version":"${isaac.version}",
					"classifier":"javadoc",
					"types":[
						"jar"
					]
				},
				{
					"group":"gov.vha.isaac.rest",
					"artifact":"isaac-rest",
					"version":"${isaac.version}",
					"classifier":"sources",
					"types":[
						"jar"
					]
				},
				{
					"group":"gov.vha.isaac.rest",
					"artifact":"isaac-rest",
					"version":"${isaac.version}",
					"classifier":null,
					"types":[
						"war",
						"pom"
					]
				}
			]
		}
		*/		
		
		Config testConfig = new Config();
		testConfig.putProperty("isaac.version", "1.8");
		testConfig.putProperty("isaac-parent.version", "3.06");
		List<String> msgs = new ArrayList<>();
		
		testConfig.addArtifacts(
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "${isaac.version}", "javadoc", asSet("jar")),
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "${isaac.version}", "sources", asSet("jar")),
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "${isaac.version}", null, asSet("war", "pom")),
				new Artifact("gov.vha.isaac.ochre", "isaac-parent", "${isaac-parent.version}", null, asSet("pom")),
				new Artifact("gov.vha.isaac.ochre.modules", "db-builder", "${isaac-parent.version}", null, asSet("pom")));
		msgs.add("Created test Config: " + testConfig);
		//System.out.println(msgs.get(msgs.size()));
		
		Config testEffectiveConfig = new Config();
		testEffectiveConfig.putProperty("isaac.version", "1.8");
		testEffectiveConfig.putProperty("isaac-parent.version", "3.06");
		testEffectiveConfig.addArtifacts(
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "1.8", "javadoc", asSet("jar")),
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "1.8", "sources", asSet("jar")),
				new Artifact("gov.vha.isaac.rest", "isaac-rest", "1.8", null, asSet("war", "pom")),
				new Artifact("gov.vha.isaac.ochre", "isaac-parent", "3.06", null, asSet("pom")),
				new Artifact("gov.vha.isaac.ochre.modules", "db-builder", "3.06", null, asSet("pom")));
		msgs.add("Created test effective Config: " + testEffectiveConfig);
		//System.out.println(msgs.get(msgs.size()));
		
		ObjectMapper mapper = new ObjectMapper();

		//Config object to JSON in file
		//mapper.writeValue(new File("testconfig.json"), testConfig);

		//Config object to JSON in String
		String jsonInString = null;
		try {
			msgs.add("Serializing object: " + testConfig);
			//System.out.println(msgs.get(msgs.size()));
			
			jsonInString = mapper.writeValueAsString(testConfig);

			msgs.add("Serialized object to JSON string: " + jsonInString);
			//System.out.println(msgs.get(msgs.size()));
		} catch (JsonProcessingException e) {
			for (String msg : msgs) {
				System.out.println(msg);
			}
			System.err.println("Failed serializing object. Caught " + e.getClass().getClass().getName() + " " + e.getLocalizedMessage());
			e.printStackTrace();
			Assert.fail("Caught exception serializing object");
		}
		//JSON string to Config object
		Config objFromJSon = null;
		try {
			//JSON from file to Object
			//Config obj = mapper.readValue(new File("c:\\configfile.json"), Config.class);

			//JSON from String to Config Object
			objFromJSon = mapper.readValue(jsonInString, Config.class);
			
			if (objFromJSon.equals(testConfig)) {
				msgs.add("Successfully serialized and deserialized");
				//System.out.println(msgs.get(msgs.size()));
			} else {
				for (String msg : msgs) {
					System.out.println(msg);
				}
				Assert.fail("FAILED testing serialization/deserialization");
			}
		} catch (IOException e) {
			for (String msg : msgs) {
				System.out.println(msg);
			}
			System.err.println("Failed serializing object. Caught " + e.getClass().getClass().getName() + " " + e.getLocalizedMessage());
			e.printStackTrace();
			Assert.fail("Failed serializing object. Caught " + e.getClass().getClass().getName() + " " + e.getLocalizedMessage());
		}
		
		Config effectiveConfigFromConfigFromJSon = Config.getEffectiveConfig(objFromJSon);
		
		if (effectiveConfigFromConfigFromJSon.equals(testEffectiveConfig)) {
			//System.out.println("Successfully extracted effective cfg\n" + effectiveConfigFromConfigFromJSon);
		} else {
			System.err.println("Effective config\n" + effectiveConfigFromConfigFromJSon + "\ndoes not match expected config\n" + testEffectiveConfig);
			Assert.fail("FAILED testing extraction of effective cfg");
		}
    }
    
    public static void main(String...argv) {
    	new ConfigTest("test").testApp();
    }
}
